<?php

class Taxonomy_Term_Addon {

  // Constructor for the taxonomy term listing. Loads options and hooks in the init method.
  public function __construct() { 
    add_action( 'vc_before_init', array( $this, 'termlisting' ) );
  }

  // Include or mapping
  function termlisting() {
    vc_map( array(
      'name' => 'Taxonomy Term Listing',
      'base' => 'taxonomy_term',
      'icon' => TAXONOMY_LISTING_ADDON_PLUGIN_URL . '/images/icon-taxonomy-listing.png',
      'class' => '',
      'category' => 'Content',
      'params' => array(
        array(
          'type' => 'Taxonomy_Names',
          'holder' => 'div',
          'class' => '',
          'heading' => __( '', 'js_composer' ),
          'param_name' => 'taxonomy_names',
          'value' => '',
          'description' => 'Select desired taxonomy name',
        ),
        array( 
          'type' => 'dropdown',
          'class' => '',
          'heading' => __( '', 'js_composer' ),
          'param_name' => 'order',
          'value' => array(
            'Ascending' => 'ASC',
            'Descending' => 'DESC'
          ),
          'description' => '',
        ),
        array(
          'type' => 'include_child_category',
          'class' => '',
          'heading' => __( '', 'js_composer' ),
          'param_name' => 'include_subcategory',
          'value' => '',
          'description' => '',
          'admin_label' => 'false',
        ),
        array(
          'type' => 'count_display',
          'class' => '',
          'heading' => __( '', 'js_composer' ),
          'param_name' => 'count',
          'value' => '',
          'description' => '',
          'admin_label' => 'false',
        ),
        array(
          'type' => 'Hide_empty',
          'class' => '',
          'heading' => __( '', 'js_composer' ),
          'param_name' => 'hide_empty',
          'value' => '',
          'description' => '',
          'admin_label' => 'false',
        ),
        array(
          'type' => 'specific_subcategory',
          'class' => '',
          'heading' => 'Enter Parent term Id',
          'param_name' => 'specific_subcategory',
          'value' => '',
          'description' => 'include any specific subcategory',
          'admin_label' => 'false',
        ),
        array(
          'type' => 'textfield',
          'class' => '',
          'heading' => 'Extra Class Name',
          'param_name' => 'extra_class_name',
          'value' => '',
          'description' => 'For styling any particular element',
          'admin_label' => 'false',
        ),
      )
    ) );
  }

  function taxonomy_name_settings_field( $settings, $value ) {
    $data = '<div class="taxonomy_name_list">' . '<select name="' . esc_attr( $settings['param_name'] ) . '" class="wpb_vc_param_value wpb-input wpb-select">';
    $data .= '<option value="">Select Taxonomy</option>';
    $post_types = get_post_types( array( 'public' => true ) );
    foreach ( $post_types as $key => $post_type_name ) {
      $taxonomy_names = get_object_taxonomies( $post_type_name );
      foreach( $taxonomy_names as $taxonomy_name ) {
        $data .= '<option value="' . $taxonomy_name . '"' . ( ( $taxonomy_name == $value ) ? 'selected' : '' ) . '>' . $taxonomy_name . '</option>';   
      }
    }
    $data .= '</select>' . '</div>'; ?>
    <script>
    (function( $ ) {
      jQuery('.taxonomy_name_list select').change(function(){
        var taxonomyValue = {
          action: "get_taxonomy_term_id",
          postdata: jQuery('.taxonomy_name_list select').val()
        }
        jQuery.post("<?php echo admin_url('admin-ajax.php'); ?>", taxonomyValue, function( response ) {
          jQuery('.parent_id_list select').empty().append(response);        
        } ); 
      });
      if ( jQuery('.taxonomy_name_list select').val() != "" ) {
        var taxonomyValue1 = {
          action: "get_taxonomy_term_id",
          postdata_selected: jQuery('.taxonomy_name_list select').val(),
          postdata_termselected: jQuery('.parent_id_list select').val()
        }
        jQuery.post("<?php echo admin_url('admin-ajax.php'); ?>", taxonomyValue1, function( response ) {
          jQuery('.parent_id_list select').empty().append(response);        
        } ); 
      }
    })( jQuery );
    </script>
    <?php return $data;
  }
 
  function include_child_settings_field( $settings, $value ) {
    $include_child_categories = '<div class="include-child"><input name="' . esc_attr( $settings['param_name'] ) . '" class="wpb_vc_param_value checkbox" type="checkbox" value="' . ( ( $value != "" ) ? $value : 1 ) . '" ' . ( $value == 1 ? checked : '' ) . '' . ( ( $value == "" ) ? checked : '' ) . ' >include Subcategory' . '</div>'; ?>
    <script>
    (function( $ ) {
      jQuery( 'input[name="include_subcategory"]' ).on( 'change', function() {
        this.value = this.checked ? 1 : 0 ;
      });
    })( jQuery );
    </script>
    <?php return $include_child_categories;
  }

  function count_display_settings_field( $settings, $value ) {
    $include_count_display = '<div class="include-count"><input name="'. esc_attr( $settings['param_name'] ) .'" class="wpb_vc_param_value checkbox" type="checkbox" value="' . ( ( $value != "" ) ? $value : 1 ) . '" ' . ( $value == 1 ? checked : '' ) . '' . ( ( $value == "" ) ? checked : '' ) . ' >show count' . '</div>'; ?>
    <script>
    (function( $ ) {
      jQuery( 'input[name="count"]' ).on( 'change', function() {
        this.value = this.checked ? 1 : 0 ;
      });
    })( jQuery );
    </script>
    <?php return $include_count_display;
  }

  function hide_empty_settings_field( $settings, $value ){
    $hide_empty_cat = '<div class="hide_empty_main"><input name="'. esc_attr( $settings['param_name'] ) .'" class="wpb_vc_param_value checkbox" type="checkbox" value="' . ( ( $value != "" ) ? $value : 1 ) . '" ' . ( $value == 1 ? checked : '' ) . '' . ( ( $value == "" ) ? checked : '' ) . ' >Hide Empty Category' . '</div>'; ?>
    <script>
    (function( $ ) {
      jQuery( 'input[name="hide_empty"]' ).on( 'change', function() {
        this.value = this.checked ? 1 : 0 ;
      });
    })( jQuery );
    </script>
    <?php return $hide_empty_cat;
  }

  function specific_subcategory_settings_field( $settings, $value ) {
    $specific_cat = '<div class="parent_id_list">' . '<select name="'. esc_attr( $settings['param_name'] ) . '" class="wpb_vc_param_value wpb-input wpb-select">';
    $specific_cat .= '<option value="' . $value . '">Select Taxonomy first</option>';  
    $specific_cat .= '</select>' . '</div>';
    return $specific_cat;
  }

  // frontend view 
  function term_listing_func( $atts ) {
    $specific_subcategory = isset( $atts['specific_subcategory'] ) ? $atts['specific_subcategory'] : 0 ;
    $order_attr = ( isset( $atts['order'] ) ? $atts['order'] : 'ASC' );
    $taxonomy_names_attr = ( isset( $atts['taxonomy_names'] ) ? $atts['taxonomy_names'] : NULL ); 
    $class = ( isset( $atts['extra_class_name']) ? "class = ".$atts['extra_class_name'] : "");
    $arguments = array( 'hide_empty' => $atts['hide_empty'], 'order' => $order_attr, 'parent'=> 0 ); 
    if ( isset( $atts['specific_subcategory'] ) || $atts['include_subcategory'] == 1 ) {
      if ( isset( $atts['specific_subcategory'] ) ) {
        $arguments = array( 'hide_empty' => $atts['hide_empty'], 'order' => $order_attr, 'parent' => $specific_subcategory ); 
      }
      $term = get_terms( $taxonomy_names_attr,$arguments );
      $response = '';
      $response = '<div class="vc_taxonomy_listing">';
      $response .= '<ul ' . $class . '>';
      foreach( $term as $terms ) {
        $response .= '<li><a href="' . get_term_link( $terms->term_id ) . '">' . $terms->name.( $atts['count'] == 1 ? '(' . $terms->count . ')' : '') . '</a>';
        if ( isset( $atts['specific_subcategory'] ) ? ( $terms->parent != 0 ) : ( $terms->parent == 0 ) ) {
          $response .= '<ul>';
          $arg_inner = array( 'hide_empty' => $atts['hide_empty'], 'order' => $order_attr, 'parent' => $terms->term_id );
          $child_terms = get_terms( $taxonomy_names_attr, $arg_inner ); 
          foreach( $child_terms as $child_term ) {
            $response .= '<li><a href="' . get_term_link( $child_term->term_id ) . '">' . $child_term->name.( $atts['count'] == 1 ? '(' . $child_term->count . ')' : '') . '</a>';
            if ( $child_term->parent != 0 ) {
              $response .= '<ul>';
              $arg_inner_child = array( 'hide_empty' => $atts['hide_empty'], 'order' => $order_attr, 'parent' => $child_term->term_id );
              $inner_child_terms = get_terms( $taxonomy_names_attr, $arg_inner_child ); 
              foreach( $inner_child_terms as $inner_child_term ) {
                $response .= '<li><a href="' . get_term_link( $inner_child_term->term_id ) . '">' . $inner_child_term->name.( $atts['count'] == 1 ? '(' . $inner_child_term->count . ')' : '') . '</a></li>';
              }
              $response .= '</ul>';
            }
          }
          $response .= '</ul></li>';
        }
      }
      $response .= '</ul>';
      return $response;
    } else {
      $term = get_terms( $taxonomy_names_attr,$arguments );
      $response = '';
      $response = '<ul>';
      foreach ($term as $terms ){
        $response .= '<li><a href="' . get_term_link( $terms->term_id ) . '">' . $terms->name . ( $atts['count'] == 1 ? '(' . $terms->count . ')' : '') . '</a></li>';
      }
      $response .= '</ul>';
      $response .= '</div>';
      return $response;
    }
  }
}
// Create obj of class.
$taxonomy_listing_obj = new Taxonomy_Term_Addon();  
vc_add_shortcode_param( 'Taxonomy_Names',  array($taxonomy_listing_obj, 'taxonomy_name_settings_field' ) );
vc_add_shortcode_param( 'include_child_category', array( $taxonomy_listing_obj, 'include_child_settings_field' ) );
vc_add_shortcode_param( 'count_display', array( $taxonomy_listing_obj, 'count_display_settings_field' ) );
vc_add_shortcode_param( 'Hide_empty', array( $taxonomy_listing_obj, 'hide_empty_settings_field' ) );
vc_add_shortcode_param( 'specific_subcategory', array( $taxonomy_listing_obj, 'specific_subcategory_settings_field' ) );
add_shortcode( 'taxonomy_term', array( $taxonomy_listing_obj, 'term_listing_func' ) );

// Ajax call for selection of parent term id. 
add_action( 'wp_ajax_get_taxonomy_term_id', 'get_taxonomy_term_id' );
add_action( 'wp_ajax_nopriv_get_taxonomy_term_id', 'get_taxonomy_term_id' );
function get_taxonomy_term_id() {
  global $wpdb;
  if ( isset( $_POST['postdata'] ) ) {
    $tax_name = sanitize_text_field( $_POST['postdata'] );
  }
  elseif ( isset( $_POST['postdata_selected'] ) ) {
    $tax_name = sanitize_text_field( $_POST['postdata_selected'] );
    $term_val = sanitize_text_field( $_POST['postdata_termselected'] );
  }
  $str="";
  if( ! empty( $tax_name ) ) {
    $arg = array( 'taxonomy' => $tax_name );
    $terms = get_categories( $arg );
    if ( isset( $_POST['postdata'] ) || isset( $_POST['postdata_termselected'] ) ) {
      $str .= '<option value="">Select Term</option>';
    }
    foreach( $terms as $term ) {
      if ( $term->parent == 0 ) {
        $str .= '<option value="' . $term->term_id . '" ' . ( $term->term_id == $term_val ? selected : '' ) . '>' . $term->name . '</option>';
      }
    }
  }
  echo $str;
  exit();
}