<?php

if ( ! class_exists( 'Theme_Options' ) ) {

    /* class ThachPham_Theme_Options sẽ chứa toàn bộ code tạo options trong theme từ Redux Framework */
    class Theme_Options {
        public $args = array();
        public $sections = array();
        public $theme;
        public $ReduxFramework;
        public function __construct() {

            if ( ! class_exists( 'ReduxFramework' ) ) {
                return;
            }

            // This is needed. Bah WordPress bugs.  <img draggable="false" class="emoji" alt="😉" src="https://s.w.org/images/core/emoji/2.3/svg/1f609.svg">
            if ( true == Redux_Helpers::isTheme( __FILE__ ) ) {
                $this->initSettings();
            } else {
                add_action( 'plugins_loaded', array( $this, 'initSettings' ), 10 );
            }

        }

        /**
        Thiết lập các method muốn sử dụng
        Method nào được khai báo trong này thì cũng phải được sử dụng
         **/
        public function initSettings() {

            // Set the default arguments
            $this->setArguments();

            // Set a few help tabs so you can see how it's done
            $this->setHelpTabs();

            // Create the sections and fields
            $this->setSections();

            if ( ! isset( $this->args['opt_name'] ) ) { // No errors please
                return;
            }

            $this->ReduxFramework = new ReduxFramework( $this->sections, $this->args );
        }

        /**
        Thiết lập cho method setAgruments
        Method này sẽ chứa các thiết lập cơ bản cho trang Options Framework như tên menu chẳng hạn
         **/
        public function setArguments()
        {
            $theme = wp_get_theme(); // Lưu các đối tượng trả về bởi hàm wp_get_theme() vào biến $theme để làm một số việc tùy thích.
            $this->args = array(
                // Các thiết lập cho trang Options
                'opt_name' => 'tp_options', // Tên biến trả dữ liệu của từng options, ví dụ: tp_options['field_1']
                'display_name' => $theme->get('Name'), // Thiết lập tên theme hiển thị trong Theme Options
                'menu_type' => 'menu',
                'allow_sub_menu' => true,
                'menu_title' => __('Design Theme Options', 'html5blank'),
                'page_title' => __('Design Theme Options', 'html5blank'),
                'dev_mode' => false,
                'customizer' => true,
                'menu_icon' => '', // Đường dẫn icon của menu option
                // Chức năng Hint tạo dấu chấm hỏi ở mỗi option để hướng dẫn người dùng */
                'hints' => array(
                    'icon' => 'icon-question-sign',
                    'icon_position' => 'right',
                    'icon_color' => 'lightgray',
                    'icon_size' => 'normal',
                    'tip_style' => array(
                        'color' => 'light',
                        'shadow' => true,
                        'rounded' => false,
                        'style' => '',
                    ),
                    'tip_position' => array(
                        'my' => 'top left',
                        'at' => 'bottom right',
                    ),
                    'tip_effect' => array(
                        'show' => array(
                            'effect' => 'slide',
                            'duration' => '500',
                            'event' => 'mouseover',
                        ),
                        'hide' => array(
                            'effect' => 'slide',
                            'duration' => '500',
                            'event' => 'click mouseleave',
                        ),
                    ),
                ) // end Hints
            );

        }
        /**
        Thiết lập khu vực Help để hướng dẫn người dùng
         **/
        public function setHelpTabs() {

            // Custom page help tabs, displayed using the help API. Tabs are shown in order of definition.
            $this->args['help_tabs'][] = array(
                'id'      => 'redux-help-tab-1',
                'title'   => __( 'Theme Information 1', 'html5blank' ),
                'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'html5blank' )
            );

            $this->args['help_tabs'][] = array(
                'id'      => 'redux-help-tab-2',
                'title'   => __( 'Theme Information 2', 'html5blank' ),
                'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'html5blank' )
            );

            // Set the help sidebar
            $this->args['help_sidebar'] = __( '<p>This is the sidebar content, HTML is allowed.</p>', 'html5blank' );
        }

        /**
        Thiết lập từng phần trong khu vực Theme Options
        mỗi section được xem như là một phân vùng các tùy chọn
        Trong mỗi section có thể sẽ chứa nhiều field
         **/
        public function setSections() {

            // General
            $this->sections []  = array(
                'id'            => 'sd_general_option',
                'title'         =>  esc_html__('General','html5blank'),
                'desc'          => '',
                'icon'          => 'el-icon-cogs',
            );

            // Topbar option
            $this->sections []  = array(
                'id'            => 'sd_topbar_option',
                'title'         => esc_html__('Top Bar','html5blank'),
                'desc'          => '',
                'icon'          =>  'el-icon-list',
                'subsection'    => true,
                'fields'        => array(
                    array(
                        'id'    => 'sd_on_of_topbar',
                        'title' => esc_html__('Enable / Disabled Top bar','html5blank'),
                        'subtitle'  => esc_html__('Enable / Disabled Top bar'),
                        'desc'      => esc_html__('Bạn có muốn bật top bar'),
                        'type'      => 'switch',
                        'default'   => 1,
                        'compiler'  => 'bool',
                        'on'        => esc_html__('Enabled','html5blank'),
                        'off'       => esc_html__('Disabled'),
                    ),
                    array(
                        'id'    => 'sd_topbar_menu',
                        'title' => esc_html__('Background','html5blank'),
                        'subtitle'  => esc_html__('Đổi màu cho top bar'),
                        'type'  => 'background',
                        'background-size'   => false,
                        'background-attachment' => false,
                        'background-position'   => false,
                        'background-repeat' => false,
                        'required'  => array('sd_on_of_topbar',"=",1),
                    ),
                    array(
                        'id'    => 'sd_padding_glyphicon',
                        'type'   => 'spacing',
                        'title'  => esc_html__('Padding Glyphicon','html5blank'),
                        'subtitle' => esc_html__('Thiết  lâpj padding cho Glyphicon'),
                        'mode'     => 'padding',
                        'compiler' => true,
                        'units'    => array('px','em'),
                        'all'      => false,
                        'output'   => array('.glyphicon'),
                        'required'  => array('sd_on_of_topbar',"=",1)
                    ),
                    array(
                        'id'        => 'sd_color_glyphicon',
                        'type'      => 'typography',
                        'title'     => esc_html__('Glyphicon color','html5blank'),
                        'subtitle'  => esc_html__('Đổi màu cho icon Glyphicon'),
                        'output'    => array('.glyphicon'),
                        'font-family'   => false,
                        'font-style'    => false,
                        'font-weight'   => false,
                        'line-height'   => false,
                        'text-align'    => false,
                        'required'  => array('sd_on_of_topbar',"=",1),
                    ),
                    array(
                        'id'        => 'sd_color_a',
                        'type'      => 'typography',
                        'title'     => esc_html__('Top bar link a','html5blank'),
                        'subtitle'  => esc_html__('Thiết lập cho thẻ a trên top bar'),
                        'output'    => array('.top-bar-menu .topbar-left ul li a','.top-bar-menu .topbar-right ul li a'),
                        'google'    => true,
                        'font-weight'   => false,
                        'text-decoration'   => true,
                        'required'  => array('sd_on_of_topbar',"=",1),
                    ),
                )
            );

            // Tạo phần search, logo, liên hệ trực tuyến
            $this->sections [] = array(
                'title'         => esc_html__('Search header','html5blank'),
                'desc'          => '',
                'icon'          => 'el-icon-search',
                'subsection'    => true,
                'fields'        => array(
                    array(
                        'id'        => 'sd-search-header',
                        'title'     => esc_html__('Enabled / Disabled search form header','html5blank'),
                        'subtitle'  => esc_html__('Bạn có muốn bật hộp thoại tìm kiếm trên header ?'),
                        'type'      => 'switch',
                        'default'   => 1,
                        'compiler'  => 'bool',
                        'on'        => esc_html__('Enabled','html5blank'),
                        'off'       => esc_html__('Disabled'),
                    ),
                    array(
                        'id'        => 'sd-search-header-padding',
                        'title'     => esc_html__('Padding / Margin','html5blank'),
                        'subtitle'  => esc_html__('Thiết lập padding / margin cho hộp thoại tìm kiếm'),
                        'type'      => 'spacing',
                        'all'       => false,
                        'units'     => array('px','em','%'),
                        'output'    => '.search',
                        'default'   => array(
                            'padding-top'   => '5',
                            'units'         => 'px',
                        ),
                        'required'  => array('sd-search-header',"=",1),
                    )
                )
            );

            // Home Section

            $this->sections[] = array(
                'title'  => __( 'Header', 'html5blank' ),
                'desc'   => __( 'All of settings for header on this theme.' ),
                'icon'   => 'el-icon-home',
                'fields' => array(
                    array(
                        'id'    =>  'logo-on',
                        'type'  => 'switch',
                        'title' => esc_html__('Enabled image logo','html5blank'),
                        'compiler' => 'bool',
                        'desc'  => 'Bạn muốn update logo',
                        'on'  => esc_html__('Enabled','html5blank'),
                        'off'  => esc_html__('Disabled'),
                    ),
                    array(
                        'id'  => 'logo-image',
                        'type'  => 'media',
                        'title'  => esc_html__('Logo Image','html5blank'),
                        'desc'  => 'Hình ảnh bạn muốn sử dụng làm logo'
                    ),
                )

            ); // end section


            // Home Section
            $this->sections[] = array(
                'title'  => __( 'Typography', 'html5blank' ),
                'desc'   => '',
                'icon'   => 'el-icon-font',
                'fields' => array(
                    array(
                        'id'          => 'sd_body_typography',
                        'type'        => 'typography',
                        'title'       => esc_html__( 'Body', 'html5blank' ),
                        'subtitle'    => esc_html__( 'Specify the body font properties.' ),
                        'output' => array( 'body' ),
                        'google'      => true,
                        'font-backup' => true,
                        'font-style'  => false,
                        'font-weight' => false,
                        'text-align'  => false,
                        'text-align'  => false,
                        'compiler'    => array( 'body' ),
                    ),
                    array(
                        'id'    =>  'sd_title_typography',
                        'type'  => 'typography',
                        'title' => esc_html__('Title','html5blank'),
                        'subtitle'=> esc_html__('Specify the title font properties'),
                        'output' => array('h4,h3'),
                        'google' =>true,
                        'font-backup' => true,
                        'font-style' => false,
                        'font-weight' => true,
                        'text-align' => false,
                    ),
                   array(
                       'id'    => 'sd_content_p',
                       'type'  => 'typography',
                       'title'  => esc_html__('p','html5blank'),
                       'subtitle' => esc_html__('Thay đổi cho thẻ p'),
                       'output' => array('p'),
                       'google' => true,
                       'font-backup' => true,
                       'font-style' => false,
                       'font-weight' =>true,
                       'text-align' => false,
                   ),
                    array(
                        'id'    => 'sd_post_p',
                        'type'  => 'typography',
                        'title' => esc_html__('Post Single','html5blank'),
                        'subtitle'  => esc_html__('Chi tiết một bài post'),
                        'sub-array'  => true,
                        'output'    => array('.post p'),
                        'google' => true,
                        'font-style'    => false,
                        'font-weight'   => false,
                        'text-alight'   =>true,
                        'line-height'   => true,
                    )
                )
            ); // end section
            // post option
            $this->sections [] = array(
                'id'            => 'post-option',
                'title'         => esc_html__('Post','html5blank'),
                'desc'          => '',
                'subsection'    => true,
                'icon'          => 'el-icon-lines',
                'fields'        => array(
                    array(
                        'id'    => 'post-title-options',
                        'title' => esc_html__('Post Title','html5blank'),
                        'subtitle'  => esc_html__('Post title (font, color,...)'),
                        'desc'      => '',
                        'type'      => 'typography',
                        'output'    => array('.post h1 a','.post h2 a','.post h3 a','.post h4 a','.post h5 a','.post h6 a'),
                        'google'    => true,
                        'font-style'    => true,
                        'font-weight'   => true,
                        'text-align'    => true,
                        'text-transform'    => true,
                        'line-height'   => true,
                    ),
                    array(
                        'id'    => 'post-date-options',
                        'title' => esc_html__('Post Date','html5blank'),
                        'subtitle'  => esc_html__('Post Date (font, color,...)'),
                        'desc'      => '',
                        'type'      => 'typography',
                        'output'    => array('.post .date'),
                        'google'    => true,
                        'font-style'    => true,
                        'font-weight'   => true,
                        'text-align'    => true,
                        'text-transform'    => true,
                        'line-height'   => true,
                    ),
                    array(
                        'id'    => 'post-author-options',
                        'title' => esc_html__('Post Author','html5blank'),
                        'subtitle'  => esc_html__('Post Author (font, color,...)'),
                        'desc'      => '',
                        'type'      => 'typography',
                        'output'    => array('.post .author','.post .author a'),
                        'google'    => true,
                        'font-style'    => true,
                        'font-weight'   => true,
                        'text-align'    => true,
                        'text-transform'    => true,
                        'line-height'   => true,
                    ),
                    array(
                        'id'    => 'post-content-options',
                        'type'  => 'typography',
                        'title' => esc_html__('Post Content','html5blank'),
                        'subtitle'  => esc_html__('Post Content (font, color,...)'),
                        'output'    => array('.post p'),
                        'google'    => true,
                        'font-style'    => true,
                        'font-weight'   => true,
                        'text-align'    => true,
                        'text-transform'    => true,
                        'line-height'   => true,
                    ),
                    array(
                        'id'    => 'sd_link_color',
                        'type'  => 'link_color',
                        'title' => esc_html__('Post Link color','html5blank'),
                        'subtitle'  => esc_html__('Các sự kiện của mouse'),
                        'output'    => '.post a',
                        'visited'   => true,
                        'focus' => true,
                    )
                )
            );

            //Thumbnail options
            $this->sections []  = array(
                'id'            => 'thumbnail-option',
                'title'         => esc_html__('Thumbnail','html5blank'),
                'desc'          => '',
                'subsection'    => true,
                'icon'          => 'el-icon-lines',
                'fields'        => array(
                    array(
                        'id'    => 'on_off_thumbnail',
                        'type'  => 'switch',
                        'title' => esc_html__('Enabled / Disabled thumbnail post single','html5blank'),
                        'subtitle'  => esc_html__('Enabled / Disabled thumbnail'),
                        'desc'      => esc_html__('Bạn có muốn bật ảnh thumbnail trong bài viết chi tiết','html5blank'),
                        'compiler'  => 'bool',
                        'on'        => esc_html__('Enabled','html5blank'),
                        'off'       => esc_html__('Disabled'),
                        'default'   => 1,
                        ),
                    array(
                        'id'    => 'post-thumbnail-options-width',
                        'type'  => 'dimensions',
                        'title' => esc_html__('Post Thumbnail','html5blank'),
                        'subtitle'  => esc_html__('Post thumbnail (width, height,..)'),
                        'units'     => array('px','em','%'),
                        'output'    => array(' .content .post a img'),
                        'default'   => array(
                            'width' => "100",
                            'units' => '%',
                        ),
                        'required'  => array('on_off_thumbnail',"=",1),
                    ),
                    array(
                        'id'        => 'post-thumbnail-option-padding',
                        'type'      => 'spacing',
                        'all'       => false,
                        'title'     => esc_html__('Padding thumbnail','html5blank'),
                        'subtitle'  => esc_html__('Padding thumbnail single post'),
                        'units'     => array('px','em','%'),
                        'output'    => array('.single-post .content .post a img'),
                        'required'  => array('on_off_thumbnail',"=",1),
                    ),
                )
            );

            $this->sections [] = array(
                'title'   => esc_html__('Background','html5blank'),
                'id'      => 'background',
                'icon'    => 'el-icon-adjust',
                'desc'    => '',
            );
            $this->sections[] = array(
                'title'     => esc_html__('Color','html5blank'),
                'desc'      => '',
                'icon'      =>'el-icon-hand-right',
                'subsection' => true,
                'fields'    => array(
                    array(
                        'id'   =>'sd_header_menu',
                        'type' => 'background',
                        'title' => esc_html__('Header menu','html5blank'),
                        'subtitle'  => esc_html__('Thay đổi màu cho menu'),
                        'output'  => array('header'),
                        'background-position' => false,
                        'background-size'  => false,
                        'background-repeat'  =>  false,
                        'background-attachment'  => false,
                    ),
                    array(
                        'id'  => 'sd_footer',
                        'type'  =>'background',
                        'title' => esc_html__('Footer background','html5blank'),
                        'subtitle' => esc_html__('Thay đổi màu cho footer'),
                        'output' => array('footer'),
                        'background-position' => false,
                        'background-size' => false,
                        'background-repeat'  =>  false,
                        'background-attachment'  => false,
                    ),
                )

            );
            $this->sections [] = array(
                'title'     => esc_html__('Border','html5blank'),
                'id'        => 'border',
                'desc'      => '',
                'subsection' => true,
                'icon'   => 'el-icon-hand-right',
                'fields'  => array(
                    array(
                        'id'  => 'sd_footer_border',
                        'type'  =>'border',
                        'title' => esc_html__('Footer Border','html5blank'),
                        'subtitle' => esc_html__('Thay đổi màu cho footer'),
                        'output' => array('.footer'),
                        'all'   => false,
                        'compiler'   => true,

                    ),
                    array(
                        'id'   => 'sd_menu_border',
                        'type'  => 'border',
                        'title' => esc_html__('Menu header border','html5blank'),
                        'subtitle' => esc_html__('Border của menu'),
                        'output'   => array('header'),
                        'all'      => false,
                        'compiler' => true,
                        'default'  => array(
                            'border-bottom' => '3',
                            'border-style'  => 'solid',
                            'border-color'  => '#FF6600',
                        )
                    ),
                    array(
                        'id'   => 'sd_width_menu',
                        'type'  => 'dimensions',
                        'title' => esc_html__('padding','html5blank'),
                        'units'  => array('px','em','%'),
                        'output' => array('header'),
                    )
                )

            );
            $this->sections []  = array(
                'title'   => esc_html__('Padding / Margin'),
                'desc'    => '',
                'icon'    => 'el-icon-resize-horizontal',
                'subsection'   => false,
                'fields'  => array(
                    array(
                        'id'   => 'sd_padding_logo',
                        'type' => 'spacing',
                        'title' => esc_html__('Padding logo','html5blank'),
                        'subtitle'  => esc_html__('Thiết lập padding cho logo'),
                        'mode' => 'padding',
                        'units_extended' => false,
                        'compiler' => true,
                        'units' => array('px','em'),
                        'all'   => false,
                        'output'  => array('.logo'),
                        'default' => array(
                            'padding-top' => '10px',
                            'padding-bottom'  => '10px',
                            'units' => 'px',
                        )
                    ),
                )
            );

            $this->sections []  = array(
                'title'         =>  esc_html__('Editor','html5blank'),
                'desc'          => '',
                'icon'          => 'el-icon-edit',
            );
            $this->sections []  = array(
                'title'         => esc_html__('Editor','html5blank'),
                'desc'          => '',
                'subsection'    => true,
                'icon'          => 'el-icon-edit',
                'fields'        =>  array(
                    array(
                        'id'    => 'sd_editor_css',
                        'type'  => 'ace_editor',
                        'title' => esc_html__('Editor Css'),
                        'subtitle'  => esc_html__('Editor css cocde'),
                        'mode'  => 'css',
                        'theme' => 'design',
                        'default'   => ".top-bar-menu {color: #fff;}"
                    ),
                    array(
                        'id'    => 'sd_editer_js',
                        'type'  => 'ace_editor',
                        'title' => esc_html__('Editor Javascript','html5blank'),
                        'subtile'   => esc_html__('Editor javascript code'),
                        'mode'  => 'javascript',
                        'theme' => 'design',
                    ),
                    array(
                        'id'    => 'sd_editor_php',
                        'type'  => 'ace_editor',
                        'title' => esc_html__('Editor PHP','html5blank'),
                        'subtitle'  => esc_html__('Editor code PHP'),
                        'mode'  => 'php',
                        'theme' => 'design',
                    )
                )
            );
            $this->sections[] = array(
                'title' => __('Footer','html5blank'),
                'desc' =>'',
                'icon' => 'el-icon-download-alt',
                'fields' => array(
                    array(
                        'id'   => 'sd_copyright_en_dis',
                        'type'  => 'switch',
                        'title' => esc_html__('Enabled/Disabled copyright','html5blank'),
                        'subtitle' => esc_html__('Enabled/Disabled copyright'),
                        'compiler' =>'bool',
                        'default'   => 1,
                        'on' => esc_html__('Enabled','html5blank'),
                        'off' => esc_html__('Disabled'),
                    ),
                    array(
                        'id'   => 'sd_copyright',
                        'type' =>'editor',
                        'title' => esc_html__('customs copyright'),
                        'subtitle' => esc_html__('Update text copyright'),
                        'default'   => '© 2017 Copyright . Design by	HOSTINGVIET.VN',
                        'args'  => array(
                            'teeny'     => true,
                            'textarea_rows' => 3
                        ),
                        'required'  => array('sd_copyright_en_dis',"=",1),
                    ),
                )
            );
            $this->sections [] = array(
                'id'        => 'socical',
                'title'     => esc_html__('Socical','html5blank'),
                'desc'      => '',
                'icon'      => 'el-icon-network',
                'fields'    => array(
                    array(
                        'id'        => 'sd_social',
                        'title'     => esc_html__('social icons','html5blank'),
                        'subtitle'  => esc_html__('Social Icons Item'),
                        'type'      => 'switch',
                        'default'   => 0,
                        'on'        => esc_html__('Enabled Social'),
                        'off'       => esc_html__('Disabled Social'),
                    ),
                    array(
                        'id'    => 'sd_social_url_item',
                        'title' => esc_html__('Social','html5blank'),
                        'subtitle'  => esc_html__('Social network url'),
                        'label' => true,
                        'type'  => 'sortable',
                        'args'  => array(
                            'facebook-square'  => "",
                            'twitter'   => "",
                            'google-plus'   => "",
                            'skype' => "",
                            'instagram' => "",
                            'behance'  => "",
                            'email' => "",
                            'vimeo-square' => "",
                            'vk'    => "",
                            'youtube-play'  => "",
                            'weibo' => "",
                            '1' => 'Item number one',
                        ),
                        'options'    => array(
                            'facebook-square'  => "",
                            'twitter'   => "",
                            'google-plus'   => "",
                            'skype' => "",
                            'instagram' => "",
                            'behance'  => "",
                            'email' => "",
                            'vimeo-square' => "",
                            'vk'    => "",
                            'youtube-play'  => "",
                            'weibo' => "",
                            '1' => 'Item number one',
                        ),
                    'required'  => array('sd_social',"=",1),
                    )

                )

            );

        }


    }
    /* Kích hoạt class ThachPham_Theme_Options vào Redux Framework */
    global $reduxConfig;
    $reduxConfig = new Theme_Options();
}