<!doctype html>
<html <?php language_attributes(); ?> class="no-js">
	<head>
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
		<meta charset="<?php bloginfo('charset'); ?>">
		<title><?php wp_title(''); ?><?php if(wp_title('', false)) { echo ' :'; } ?> <?php bloginfo('name'); ?></title>

		<link href="//www.google-analytics.com" rel="dns-prefetch">
        <link href="<?php echo get_template_directory_uri(); ?>/img/icons/favicon.ico" rel="shortcut icon">
        <link href="<?php echo get_template_directory_uri(); ?>/img/icons/touch.png" rel="apple-touch-icon-precomposed">

		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta name="description" content="<?php bloginfo('description'); ?>">
		<?php wp_head(); ?>
		<script>
        // conditionizr.com
        // configure environment tests
        conditionizr.config({
            assets: '<?php echo get_template_directory_uri(); ?>',
            tests: {}
        });
        </script>
		<script>
			(function() {
				var cx = '005155181200832216853:va_qft__8ji';
				var gcse = document.createElement('script');
				gcse.type = 'text/javascript';
				gcse.async = true;
				gcse.src = 'https://cse.google.com/cse.js?cx=' + cx;
				var s = document.getElementsByTagName('script')[0];
				s.parentNode.insertBefore(gcse, s);
			})();
		</script>

	</head>
	<body <?php body_class(); ?>>
	<div class="top-bar-menu">
		<div class="container">
			<div class="row">
				<div class="col-sm-4 topbar-left">
					<?php topbar_left_menu(); ?>
				</div>
				<div class="col-sm-5 topbar-right">
					<?php #topbar_right_menu(); ?>
				</div>
				<div class="col-sm-3 topbar-login">
					<?php topbar_login_menu();?>
				</div>
			</div>
		</div>
	</div>
	<!-- tạo search header	-->
	<div class="header-search">
		<div class="container">
			<div class="row"></div>
		</div>
	</div>
	<!-- header -->
	<header class="header clear" role="banner">
		<div class="container">
			<div class="row menu-header">
				<div class="col-sm-2 col-xs-2 logo-header">
					<!-- logo -->
					<div class="logo">
						<a href="<?php echo home_url(); ?>">
							<!-- svg logo - toddmotto.com/mastering-svg-use-for-a-retina-web-fallbacks-with-png-script -->
							<!--<img src="<?php #echo get_template_directory_uri(); ?>/img/logo.svg" alt="Logo" class="logo-img">-->
							<?php html5blank_logo();?>
						</a>
					</div>
					<!-- /logo -->
				</div>
				<div class="col-sm-10 col-xs-10">
					<!-- nav -->
					<nav class="nav navbar navbar-default" role="navigation">
						<!-- Brand and toggle get grouped for better mobile display -->
						<div class="navbar-header">
							<button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-ex1-collapse">
								<span class="sr-only">Toggle navigation</span>
								<span class="icon-bar"></span>
								<span class="icon-bar"></span>
								<span class="icon-bar"></span>
							</button>
						</div>

						<!-- Collect the nav links, forms, and other content for toggling -->
						<div class="collapse navbar-collapse navbar-ex1-collapse">
						<?php html5blank_nav(); ?>
						</div>
					</nav>
					<!-- /nav -->
				</div>
			</div>
			<div class="masthead">
				<div class="container">
					<div class="row">
						<div class="header-widget">
							<?php if( is_active_sidebar('header-widget') ) : dynamic_sidebar('header-widget'); endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>

	</header>
	<!-- /header -->


		<!-- wrapper -->

			<!--/content -->
			<div id="content" class="content">
