<?php
/*
 Template Name: Đăng Nhập
 */
get_header(); ?>
<div class="container">
    <div class="row">
        <div class="col-sm-8">
            <main role="main">
                <div class="breadcrumb-single">
                    <div class="container">
                        <?php if(function_exists('dimox_breadcrumbs'))
                        {
                            dimox_breadcrumbs();
                        }?>
                    </div>
                </div>
                <!-- section -->
                <section>

                    <h1><?php the_title(); ?></h1>

                    <?php if (have_posts()): while (have_posts()) : the_post(); ?>

                        <?php if(is_user_logged_in()) { $user_id = get_current_user_id();$current_user = wp_get_current_user();$profile_url = get_author_posts_url($user_id);$edit_profile_url  = get_edit_profile_url($user_id); ?>
                            <div class="regted">
                                Bạn đã đăng nhập với tên nick <a href="<?php echo $profile_url ?>"><?php echo $current_user->display_name; ?></a> Bạn có muốn <a href="<?php echo esc_url(wp_logout_url($current_url)); ?>">Thoát</a> không ?
                            </div>
                        <?php } else { ?>
                            <div class="formdangnhap">
                                <?php wp_login_form(); ?>
                            </div>
                            <p>Bạn chưa có tài khoản, Click <a href="/dang-ky/">vào đây </a>để đăng ký...!</p>
                        <?php } ?>

                    <?php endwhile; ?>

                    <?php else: ?>

                        <!-- article -->
                        <article>

                            <h2><?php _e( 'Sorry, nothing to display.', 'html5blank' ); ?></h2>

                        </article>
                        <!-- /article -->

                    <?php endif; ?>

                </section>
                <!-- /section -->
            </main>
        </div>
        <div class="col-sm-4">
            <?php get_sidebar(); ?>
        </div>
    </div>
</div>


<?php get_footer(); ?>
