<?php get_header(); ?>
<?php $cat = get_the_category( get_the_ID() ); ?>

	<main role="main">
		<div class="breadcrumb-single">
			<div class="container">
				<?php if(function_exists('dimox_breadcrumbs'))
				{
					dimox_breadcrumbs();
				}?>
			</div>
		</div>
		<div class="container">
			<!-- section -->
			<div class="col-sm-8">
			<section>

			<?php if (have_posts()): while (have_posts()) : the_post(); ?>
				<?php postview_set(get_the_ID()); ?>
				<!-- article -->
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<!-- post title -->
					<h2>
						<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a>
					</h2>
					<!-- post details -->
					<span class="date">Created: <?php the_time('F j, Y'); ?> | </span>
					<span class="date">Last Updated: </span><?php the_modified_time('F j, Y');?></span>
					<span><a href="#respond"><?php echo " | " ?><i class="fa fa-comments-o"> : </i> <?php comments_number()?></span></a>
					<p class="author"><?php _e( 'Author:', 'html5blank' ); ?> <?php the_author_posts_link(); ?></p>
					<span class="comments"><?php #if (comments_open( get_the_ID() ) ) comments_popup_link( __( 'Leave your thoughts', 'html5blank' ), __( '1 Comment', 'html5blank' ), __( '% Comments', 'html5blank' )); ?></span>
					<!-- /post details -->
					<!-- /post title -->
					<!-- post thumbnail -->
					<hr>

					<?php if ( has_post_thumbnail()) : // Check if Thumbnail exists ?>

						<?php echo html5blank_thumbnail();?>
						
					<?php endif; ?>
					<!-- /post thumbnail -->


					<?php the_content(); // Dynamic Content ?>
					<hr>
					<div class="row" id="socical-share">
						<div class="col-sm-4"></div>
						<div class="col-sm-8">
						<div class="socical-share">
							<ul class="social-sharing">
								<span>Share this post => </span>
								<li class="social-sharing_item">
									<a href="https://www.facebook.com/sharer/sharer.php?u=" class="social-sharing__link"><span class="fa fa-facebook"></span></a>
								</li>
								<li class="social-sharing_item">
									<a href="https://twitter.com/home?status=" class="social-sharing__link"><span class="fa fa-twitter"></span></a>
								</li>
								<li class="social-sharing_item">
									<a href="#" class="social-sharing__link"><span class="fa fa-instagram"></span></a>
								</li>
							</ul>
						</div>
						</div>
					</div>
					<?php the_tags( __( 'Tags: ', 'html5blank' ), ', ', '<br>'); // Separated by commas with a line break at the end ?>

					<p><?php# _e( 'Categorised in: ', 'html5blank' ); the_category(', '); // Separated by commas ?></p>

					<?php edit_post_link(); // Always handy to have Edit Post Links available ?>
				</article>
				<!-- /article -->

			<?php endwhile; ?>

			<?php else: ?>

				<!-- article -->
				<article>

					<h1><?php _e( 'Sorry, nothing to display.', 'html5blank' ); ?></h1>

				</article>
				<!-- /article -->

			<?php endif; ?>
				<hr>
				<?php
				if ($cat) {
					$t = $cat[0];
					$r = new WP_Query(array('posts_per_page'=> 4, 'post__not_in'=> array( get_the_ID() ), 'cat'=> $t->term_id ));
					echo '<h3 class="relate-title">Bài Viết Cùng Chủ Đề</h3>';
					echo '<br>';
					echo '<div class="show-more-post">';
					while ( $r->have_posts()): $r->the_post();
						echo '<div class="ovf">';
						echo '<a href="'.get_permalink().'">'.'<li class="mh block">'.get_the_title().'</li></a>';
						echo '</div>';
					endwhile;
					echo '</div>';
					wp_reset_postdata();
				}
				?>

				<div class="author-wrap">
					<div class="author-gravatar">
						<?php echo get_avatar( get_the_author_meta( 'ID' ), 100 ); ?>
					</div>
					<div class="author-info">
						<div class="vcard author author-title">
										<span class="fn">
												<a target="_blank" class="ext-link" href="<?php the_author_meta('user_url'); ?>" title="Ghé thăm website của <?php the_author_meta('user_login'); ?>" rel="author external nofollow"><?php the_author_meta('display_name'); ?></a>
										</span>
						</div>
						<div class="author-description"><?php the_author_meta('description'); ?></div>
						<ul>
							<li class="first">
								<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>">Xem bài của <?php the_author_meta('user_login'); ?> <span class="meta-nav">→</span></a>
							</li>
							<li>
								<a target="_blank" class="ext-link" rel="external nofollow" href="<?php the_author_meta('user_url'); ?>" title="Ghé thăm trang chủ của <?php the_author_meta('user_login'); ?>">Blog</a>
							</li>
							<li>
								<a target="_blank" class="ext-link" href="<?php echo get_the_author_meta( 'twitter' ); ?>" title="Theo dõi <?php the_author_meta('user_login'); ?> trên Twitter" rel="external nofollow">Twitter</a>
							</li>
							<li>
								<a target="_blank" class="ext-link" href="<?php echo get_the_author_meta( 'facebook' ); ?>" title="Theo dõi <?php the_author_meta('user_login'); ?> trên Facebook" rel="external nofollow">Facebook</a>
							</li>
							<li>
								<a target="_blank" class="ext-link" href="<?php echo get_the_author_meta( 'googleplus' ); ?>" title="Theo dõi <?php the_author_meta('user_login'); ?> trên Goolge Plus" rel="external nofollow">Google Plus</a>
							</li>
						</ul>
					</div>
				</div>

				<?php comments_template(); ?>

			</section>
			<!-- /section -->
			</div>
			<div class="col-sm-4">
				<div class="row">
					<?php get_sidebar(); ?>
				</div>
			</div>
		</div>
	</main>


<?php get_footer(); ?>
