<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 5/10/2017
 * Time: 14:03 PM
 */

class vcNews extends WPBakeryShortCode {

    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'vc_news_mapping' ) );
        add_shortcode( 'vc_news', array( $this, 'vc_news' ) );
    }

    // Element Mapping
    public function vc_news_mapping() {

        // Kiểm tra phiên bản của visual composer
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }

        // Tạo element bằng vc_map()
        vc_map(

            array(
                'name' => __('VC News', 'text-domain'), //Tên của element
                'base' => 'vc_news', // base của element
                'description' => __('Mô tả element', 'text-domain'),
                'category' => __('My Element', 'text-domain'),   // Đưa vào category khi sử dụng nhiều element
                'icon' => get_template_directory_uri().'/img/icons/backpack-icon.png', // Icon cho element
                'params' => array(

                    array(
                        'type' => 'textfield',
                        'holder' => 'h3',
                        'class' => 'title-class',
                        'heading' => __( 'Title', 'text-domain' ),
                        'param_name' => 'title',
                        'value' => __( 'Default value', 'text-domain' ),
                        'description' => __( 'Box Title', 'text-domain' ),
                        'admin_label' => false,
                        'weight' => 0,
                        'group' => 'Custom Group',
                    ),

                    array(
                        'type' => 'textarea',
                        'holder' => 'div',
                        'class' => 'text-class',
                        'heading' => __( 'Text', 'text-domain' ),
                        'param_name' => 'text',
                        'value' => __( 'Default value', 'text-domain' ),
                        'description' => __( 'Box Text', 'text-domain' ),
                        'admin_label' => false,
                        'weight' => 0,
                        'group' => 'Custom Group',
                    )
                )
            )
        );


    }

    // Element HTML
    public function vc_news( $atts ) {

        extract(
            shortcode_atts(
                array(
                    'title'   => '',
                    'text' => '',
                    'decription' => '',
                ),
                $atts
            )
        );


        $html = '
    <div class="vc-infobox-wrap">
     
        <h2 class="vc-infobox-title">' . $title . '</h2> 
         
        <div class="vc-infobox-text">' . $text . '</div>
        
        <div class="vc-infobox-text">'.$decription.'</div>
        
    </div>';

        return $html;

    }

} // End Element Class

// Element Class Init
new vcNews();