<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 5/10/2017
 * Time: 8:41 AM
 */
// Them css va javascript vao giua the head
function sw_styles_and_scripts() {
    wp_register_style('html5blank-custom-style', get_template_directory_uri().'/designhtml/custom-style.css');
    wp_enqueue_style('html5blank-custom-style');
}
add_action('wp_enqueue_scripts', 'sw_styles_and_scripts');


function stheme_add_boostrap() {
    wp_register_style('bootstrap-style', get_template_directory_uri() . '/designhtml/bootstrap.css');
    wp_enqueue_style('bootstrap-style');

    wp_register_script('bootstrap', get_template_directory_uri() . '/designhtml/bootstrap.min.js', array(), false, true);
    wp_enqueue_script('bootstrap');
    
}
add_action('wp_enqueue_scripts', 'stheme_add_boostrap');

// Them vao cac chuc nang ho tro cua giao dien
if (function_exists('add_theme_support'))
{
    // Khai bao kich thuoc cho hinh anh thumbnail khi xem bai viet
    add_image_size('custom-single-size', 300, 175, true);

    // Khai bao kich thuoc cho hinh anh thumbnail khi duyet danh sach bai viet
    add_image_size('custom-home-size', 1004, auto, true);
}

if (! function_exists('html5blank_thumbnail')){
    function html5blank_thumbnail(){?>
        <?php
        global $tp_options;
        ?>
        <?php if ( $tp_options['on_off_thumbnail'] == 1 ) : ?>
            
                <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                    <?php the_post_thumbnail(); // Fullsize image for the single post ?>
                </a>

        <?php else : ?>

        <?php endif;
    }
}
if(!function_exists('html5blank_copyright')){
    function  html5blank_copyright(){ ?>
        <?php
        global $tp_options;
        ?>
        <?php
        if ($tp_options ['sd_copyright_en_dis'] == 1):
        ?>
            <p><?php echo $tp_options['sd_copyright'];  ?></p>
        <?php else : ?>
        <?php endif;
    }
}

// social network
if (!function_exists('html5blank_social_network')){
    function html5blank_social_network(){ ?>
        <?php global $tp_options;?>
        <?php
        if ($tp_options['sd_social' == 1]):
        ?>
            
        <?php else : ?>
        <?php endif;
    }
}

	if (!function_exists('html5_search')){
        function html5_search(){ ?>
            <?php global $tp_options;?>
            <?php
            if ($tp_options ['sd-search-header'] == 1) : ?>
                <!-- search -->
                <form class="search" method="get" action="<?php echo home_url(); ?>" role="search">
                    <div class="row">
                        <div class="col-sm-10">
                            <input class="search-input" type="search" name="s" placeholder="<?php _e( 'Nhập nội dung tìm kiếm ?', 'html5blank' ); ?>">
                        </div>
                        <div class="col-sm-2">
                            <button class="search-submit" type="submit" role="button"><?php _e( 'Search', 'html5blank' ); ?></button>
                        </div>
                    </div>
                </form>
                <!-- /search -->
            <?php else : ?>
            <?php endif;
        }
    }



if ( ! function_exists( 'html5blank_logo' ) ) {
    function html5blank_logo() {?>
        <?php
        global $tp_options;
        ?>

        <?php if ( $tp_options['logo-on'] == 1 ) : ?>

            <div class="logo">
                <img src="<?php echo $tp_options['logo-image']['url']; ?>">
            </div>

        <?php else : ?>

            <div class="logo">

                <div class="site-name">
                    <?php if ( is_home() ) {
                        printf(
                            '<h1><a href="%1$s" title="%2$s">%3$s</a></h1>',
                            get_bloginfo( 'url' ),
                            get_bloginfo( 'description' ),
                            get_bloginfo( 'sitename' )
                        );
                    } else {
                        printf(
                            '<a href="%1$s" title="%2$s">%3$s</a>',
                            get_bloginfo( 'url' ),
                            get_bloginfo( 'description' ),
                            get_bloginfo( 'sitename' )
                        );
                    } // endif ?>
                </div>
                <div class="site-description"><?php bloginfo( 'description' ); ?></div>

            </div>

        <?php endif;
    }
}

class STheme_Customize {
    public static function register ( $wp_customize ) {
        $wp_customize->add_section( 'stheme_options_section', array(
                'title' => __( 'Cài đặt giao diện', 'html5blank' ),
                'priority' => 35,
                'capability' => 'edit_theme_options',
                'description' => __('Cài đặt tùy chọn cho giao diện.', 'html5blank'),
            )
        );
        $wp_customize->add_setting( 'stheme_options[logo_url]', array(
                'default' => '',
                'type' => 'option',
                'capability' => 'edit_theme_options',
                'transport' => 'postMessage',
            )
        );
        $wp_customize->add_control( 'stheme_logo_url', array(
                'label' => __( 'Logo Url', 'html5blank' ),
                'section' => 'stheme_options_section',
                'settings' => 'stheme_options[logo_url]',
                'priority' => 10,
            )
        );

        $wp_customize->add_setting( 'stheme_options[banner_url]', array(
                'default' => '',
                'type' => 'option',
                'capability' => 'edit_theme_options',
                'transport' => 'postMessage',
            )
        );
        $wp_customize->add_control( 'stheme_banner_url', array(
                'label' => __( 'Banner Url', 'html5blank' ),
                'section' => 'stheme_options_section',
                'settings' => 'stheme_options[banner_url]',
                'priority' => 10,
            )
        );

        $wp_customize->get_setting( 'stheme_options[logo_url]' )->transport = 'postMessage';
        $wp_customize->get_setting( 'stheme_options[banner_url]' )->transport = 'postMessage';
    }
}
add_action( 'customize_register' , array( 'STheme_Customize' , 'register' ) );


// Before VC Init
add_action( 'vc_before_init', 'vc_before_init_actions' );

function vc_before_init_actions() {

    // Require new custom Element
    require_once( get_template_directory().'/vc-composer/my-element.php' );

}

function dimox_breadcrumbs() {

    $delimiter = '>';

    $home = 'Trang chủ'; // ch? thay th? cho ph?n 'Home' link

    $before = '<span property="itemListElement" typeof="ListItem" itemscope="" itemtype="http://data-vocabulary.org/Breadcrumb">'; // th? html ð?ng trý?c m?i link
    $after = '</span>'; // th? ð?ng sau m?i link

    if ( !is_home() && !is_front_page() || is_paged() ) {

        echo '<ul class="clearfix" typeof="BreadcrumbList" vocab="http://schema.org/">';

        global $post;

        $homeLink = get_bloginfo('url');

        echo '<li class="dimox_breadcrumbs" property="itemListElement" typeof="ListItem" itemscope="" itemtype="http://data-vocabulary.org/Breadcrumb">
<a href="' . $homeLink . '" property="item" typeof="WebPage" title="ThangKV@hostingviet" href="' . $homeLink . '" itemprop="url">' . $home . '</a><meta property="position" content="1"></li> ' . $delimiter . ' ';

        if ( is_category() ) {

            global $wp_query;

            $cat_obj = $wp_query->get_queried_object();

            $thisCat = $cat_obj->term_id;

            $thisCat = get_category($thisCat);

            $parentCat = get_category($thisCat->parent);

            if ($thisCat->parent != 0) echo(get_category_parents($parentCat, TRUE, ' ' . $delimiter . ' '));

            echo $before . 'Danh mục "' . single_cat_title('', false) . '"' . $after;

        } elseif ( is_day() ) {

            echo '<li><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ' . $delimiter . ' ';

            echo '<li><a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a></li> ' . $delimiter . ' ';

            echo $before . get_the_time('d') . $after;

        } elseif ( is_month() ) {

            echo '<li><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ' . $delimiter . ' ';

            echo $before . get_the_time('F') . $after;

        } elseif ( is_year() ) {

            echo $before . get_the_time('Y') . $after;

        } elseif ( is_single() && !is_attachment() ) {

            if ( get_post_type() != 'post' ) {

                $post_type = get_post_type_object(get_post_type());

                $slug = $post_type->rewrite;

                echo '<li><a href="' . $homeLink . '/' . $slug['slug'] . '/">' . $post_type->labels->singular_name . '</a></li> ' . $delimiter . ' ';

                echo $before . get_the_title() . $after;

            } else {

                $cat = get_the_category(); $cat = $cat[0];


                echo $before. '<a property="item" typeof="WebPage" title="'.$cat->name.'" href="' . $homeLink . '/cat/'.$cat->slug.'" class="taxonomy category" itemprop="url">
<span itemprop="title" property="name">'.$cat->name.'</span> 
</a> <meta property="position" content="2">' . $after . ' > ' ;


                echo $before. '<a property="item" typeof="WebPage" title="'.$cat->name.'" href="' . get_the_permalink() .'" class="taxonomy category" itemprop="url">
<span itemprop="title" property="name">'.get_the_title().'</span> 
</a> <meta property="position" content="3">' . $after;



            }

        } elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {

            $post_type = get_post_type_object(get_post_type());

            echo $before . $post_type->labels->singular_name . $after;

        } elseif ( is_attachment() ) {

            $parent = get_post($post->post_parent);

            $cat = get_the_category($parent->ID); $cat = $cat[0];

            echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');

            echo '<li><a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a></li> ' . $delimiter . ' ';

            echo $before . get_the_title() . $after;

        } elseif ( is_page() && !$post->post_parent ) {

            echo $before . get_the_title() . $after;

        } elseif ( is_page() && $post->post_parent ) {

            $parent_id = $post->post_parent;

            $breadcrumbs = array();

            while ($parent_id) {

                $page = get_page($parent_id);

                $breadcrumbs[] = '<li><a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a></li>';

                $parent_id = $page->post_parent;

            }

            $breadcrumbs = array_reverse($breadcrumbs);

            foreach ($breadcrumbs as $crumb) echo $crumb . ' ' . $delimiter . ' ';

            echo $before . get_the_title() . $after;

        } elseif ( is_search() ) {

            echo $before . 'Tìm kiếm cho "' . get_search_query() . '"' . $after;

        } elseif ( is_tag() ) {

            echo $before . 'Thẻ tag "' . single_tag_title('', false) . '"' . $after;

        } elseif ( is_author() ) {

            global $author;

            $userdata = get_userdata($author);

            echo $before . 'Đăng bởi ' . $userdata->display_name . $after;

        } elseif ( is_404() ) {

            echo $before . 'Lỗi 404' . $after;

        }

        if ( get_query_var('paged') ) {

            if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';

            echo __('Page') . ' ' . get_query_var('paged');

            if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';

        }

        echo '

</ul>';

    }

} // end dimox_breadcrumbs()

// Register Custom Navigation Walker


// Xóa bỏ tiền tố đầu trước post name
// Remove Parent Category from Child Category URL
add_filter('term_link', 'devvn_no_category_parents', 1000, 3);
function devvn_no_category_parents($url, $term, $taxonomy) {
    if($taxonomy == 'category'){
        $term_nicename = $term->slug;
        $url = trailingslashit(get_option( 'home' )) . user_trailingslashit( $term_nicename, 'category' );
    }
    return $url;
}
// Rewrite url mới
function devvn_no_category_parents_rewrite_rules($flash = false) {
    $terms = get_terms( array(
        'taxonomy' => 'category',
        'post_type' => 'post',
        'hide_empty' => false,
    ));
    if($terms && !is_wp_error($terms)){
        foreach ($terms as $term){
            $term_slug = $term->slug;
            add_rewrite_rule($term_slug.'/?$', 'index.php?category_name='.$term_slug,'top');
            add_rewrite_rule($term_slug.'/page/([0-9]{1,})/?$', 'index.php?category_name='.$term_slug.'&paged=$matches[1]','top');
            add_rewrite_rule($term_slug.'/(?:feed/)?(feed|rdf|rss|rss2|atom)/?$', 'index.php?category_name='.$term_slug.'&feed=$matches[1]','top');
        }
    }
    if ($flash == true)
        flush_rewrite_rules(false);
}
add_action('init', 'devvn_no_category_parents_rewrite_rules');

/*Sửa lỗi khi tạo mới category bị 404*/
function devvn_new_category_edit_success() {
    devvn_no_category_parents_rewrite_rules(true);
}
add_action('created_category','devvn_new_category_edit_success');
add_action('edited_category','devvn_new_category_edit_success');
add_action('delete_category','devvn_new_category_edit_success');



add_action( 'wp_footer', 'cswp_back_to_top_script' );
function cswp_back_to_top_script() {
    echo '<script type="text/javascript">
        jQuery(document).ready(function($){
            $(window).scroll(function () {
                if ( $(this).scrollTop() > 400 )
                    $("#totop").fadeIn();
                else
                    $("#totop").fadeOut();
            });
 
            $("#totop").click(function () {
                $("body,html").animate({ scrollTop: 0 }, 800 );
                return false;
            });
        });
    </script>';
}

add_action( 'wp_head', 'cswp_back_to_top_stylesheet' );
function cswp_back_to_top_stylesheet() {
    echo '<style type="text/css">
        #totop {
            background-image: url("http://localhost/designhtml5/wp-content/uploads/2017/10/back-to-top.png");
            height: 40px;
            width: 40px;
            position: fixed;
            right: 30px;
            bottom: 30px;
            display: none;
            outline: none;
            border-radius: 50%;
        }
    </style>';
}

add_action( 'wp_footer', 'add_back_to_top' );
function add_back_to_top() {
    echo '<a id="totop" href="#">'.'</a>';
}

// Lay 5 bai viet moi nhat theo category
function cswp_postsbycategory() {
    $the_query = new WP_Query( array( 'category_name' => '', 'posts_per_page' => 5 ) );

    if ( $the_query->have_posts() ) {
        $string .= '<ul class="postsbycategory widget_recent_entries">';
        while ( $the_query->have_posts() ) {
            $the_query->the_post();
            $string .= '<li><i class="fa fa-file-o"></i><a href="' . get_the_permalink() .'" rel="bookmark">' . get_the_title() .'</a></li>';
        }
    }else{
    }
    $string .= '</ul>';

    return $string;
    wp_reset_postdata();
}

//Lay tong so baif viet trong mot category
//[category_post_count category="category_slug_or_name"] (cach su dung)
// Add Shortcode to show posts count inside a category
function category_post_count( $atts ) {

    $atts = shortcode_atts( array(
        'category' => null
    ), $atts );

    // get the category by slug.
    $term = get_term_by( 'slug', $atts['category'], 'category');

    return ( isset( $term->count ) ) ? $term->count : 0;
}


add_shortcode('categoryposts', 'cswp_postsbycategory');
add_shortcode( 'category_post_count', 'category_post_count' );
add_filter('widget_text', 'do_shortcode');



require_once ("class-tgm-plugin-activation.php");
require_once ("plugins.php");
require_once ("options.php");

