<?php if (have_posts()): while (have_posts()) : the_post(); ?>

	<!-- article -->
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<div class="row">

			<div class="col-sm-5">
				<!-- post thumbnail -->
				<?php if ( has_post_thumbnail()) : // Check if thumbnail exists ?>
					<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
						<?php the_post_thumbnail(array(1044,auto)); // Declare pixel size you need inside the array ?>
					</a>
				<?php endif; ?>
				<!-- /post thumbnail -->
			</div>
			<div class="col-sm-7">
				<!-- post title -->
				<h2>
					<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a>
				</h2>
				<!-- /post title -->

				<!-- post details -->
				<span class="date"><i class="fa fa-calendar-check-o"> : </i> <?php the_time('F j, Y'); ?> <?php #the_time('g:i a'); ?></span>
				<span class="author"><?php echo "|" ." ". '<i class="fa fa-user">'.'</i>'." : ";?><?php the_author_posts_link();?></span>
				<span><?php echo " | " ?><i class="fa fa-comments-o"> : </i> <?php comments_number()?></span>
				<span class="postview_get"><i class="glyphicon glyphicon-eye-open"></i><?php echo postview_get(get_the_ID()); ?></span>
				<span class="author"><?php# _e( 'Published by', 'html5blank' ); ?> <?php #the_author_posts_link(); ?></span>
				<span class="comments"><?php# if (comments_open( get_the_ID() ) ) comments_popup_link( __( 'Leave your thoughts', 'html5blank' ), __( '1 Comment', 'html5blank' ), __( '% Comments', 'html5blank' )); ?></span>
				<!-- /post details -->

				<?php html5wp_excerpt('html5wp_index'); // Build your custom callback length in functions.php ?>
				<a class="read-more" href="<?php the_permalink();?>">Xem thêm...!</a>

				<?php #edit_post_link(); ?>
			</div>


		</div>

	</article>
	<!-- /article -->
	<hr class="line-height">

<?php endwhile; ?>

<?php else: ?>

	<!-- article -->
	<article>
		<h2><?php _e( 'Sorry, nothing to display.', 'html5blank' ); ?></h2>
	</article>
	<!-- /article -->

<?php endif; ?>
